figure1 = figure('Color',[1 1 1],'rend','painters','units','centimeters','pos',[0.1 0.1 15 10]);
x = cell2mat(CD07mar19(3:78,1));
y1 = cell2mat(CD07mar19(3:78,2));
y2 = cell2mat(CD07mar19(3:78,3));
y3 = cell2mat(CD07mar19(3:78,4));
y4 = cell2mat(CD07mar19(3:78,5));

hold on
title('3 months (frozen-thawed) CD spectra');
p1 = plot(x,y1);
p2 = plot(x,y2);
p3 = plot(x,y3);
p4 = plot(x,y4);
l1 = line([180 260 ],[0 0]);
l1.LineStyle = '--';
l1.Color= 'k';
p1.LineStyle = '--';
p2.LineStyle = '-.';
p3.LineStyle = ':';
p4.LineStyle = '-';
ylabel(['\Delta',char(949)']);
xlabel('Wavelength (nm)');
l1 =legend('Ensilicated lysozyme (released)','Lysozyme in buffer (thawed)','Lyophilised lysozyme (reconstituted)','Non-frozen lysozyme (native)')
set(l1,'Box','off');
xlim([185 260]);
% Create arrow
annotation(figure1,'arrow',[0.196 0.196],[0.8982 0.7728]);
% Create arrow
annotation(figure1,'arrow',[0.436 0.436],[0.2806 0.3968]);
set([p1 p2 p3 p4],'LineWidth',1.15);
set([p3],'LineWidth',2);
set(figure1,'PaperPositionMode','auto');
set(figure1,'PaperSize',[figure1.PaperPosition(3) figure1.PaperPosition(4)]); 